using System;
using System.Drawing;
using System.Windows.Forms;
using System.Configuration;
using System.Collections.Specialized;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.GUI.controls;
using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// VistA sign-on dialog asking user for VistA access and verify codes.
	/// </summary>
	public class DlgVistASignOn : DlgVistABase
	{
		private const char VISTA_SECURITY_CODES_USER_CONVENIENCE_DELIMITER = ';';
		private const string VISTA_SECURITY_CODES_USER_CONVENIENCE_DELIMITER_CHAR_NAME = "semicolon";
		private const char PASSWORD_CHAR = '*';

		private Label lblVerifyCode;
		private Label lblAccessCode;

		private TextBox txtIntroText;		
		private TextBox txtAccessCode;
		private TextBox txtVerifyCode;

		private CheckBox chbChangeVerifyCode;

		private VbecsButton btnCancel;
		private VbecsButton btnSignOn;

		private GroupBox grpbIdentificationRequired;				

		private PictureBox pbVALogo;

		private bool _singleEntryMode;
		private bool _multipleDelimitersErrorSetFlag;

		/// <summary>
		/// Default parameterless constructor. Added for VS.NET designer support.
		/// </summary>
		protected internal DlgVistASignOn()
			: base()
		{
			InitializeComponent();
			this.btnCancel.Text = "Cancel";
			this.btnSignOn.Text = "Log On";
		
		}

		/// <summary>
		/// Actual constructor that should be used by the application.
		/// </summary>
		/// <param name="serverInfo">Remote VistA server info.</param>
		/// <param name="serverConnectionInfo"></param>
		public DlgVistASignOn( RemoteServerSetupAndIntroInfo serverInfo, ServerConnectionInfo serverConnectionInfo )
			: base( serverInfo, serverConnectionInfo )
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();	
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC102.DlgVistASignOn());

			this.SetControlBindings( this.btnSignOn, this.btnCancel, this.txtAccessCode );
			this.txtIntroText.Text = this.ServerInfo.IntroText; 

			this.txtAccessCode.TextChanged += new EventHandler( AccessCodeTextBox_TextChanged );

			_singleEntryMode = false;
			_multipleDelimitersErrorSetFlag = false;

#if DEBUG	// Prepopulating access & verify codes for debug purposes (not to enter codes every time).

			NameValueCollection _configFileSettings = (NameValueCollection)System.Configuration.ConfigurationManager.GetSection( 
				GlobalConfig.GetXPathToChildConfigSection( "DebugAccessList" ) );
			this.btnCancel.Text = "Cancel";
			this.btnSignOn.Text = "Log On";

			// Check if config section exists
			if( _configFileSettings == null ) 
				return;			

			string _accessAndVerifyCodesPair = _configFileSettings[ Common.LogonUser.LogonUserName.ToUpper() ];

			if( _accessAndVerifyCodesPair == null )
				return;

			string[] _codes = _accessAndVerifyCodesPair.Split( new char[] { '^' } );

			txtAccessCode.Text = _codes[0];
			txtVerifyCode.Text = _codes[1];					
#endif
			AccessCodeTextBox_TextChanged( txtAccessCode, EventArgs.Empty );
			
			this.btnCancel.Text = "Cancel";

		}

#if DEBUG
		private static bool DEBUG_FIRST_TIME_CLICK = true;

		/// <summary>
		/// VisibleChanged Event
		/// </summary>
		/// <param name="e"></param>
		protected override void OnVisibleChanged(EventArgs e)
		{
			base.OnVisibleChanged (e);

			if( !DEBUG_FIRST_TIME_CLICK )
				return;

			DEBUG_FIRST_TIME_CLICK = false;
			
			this.AcceptButton.PerformClick();
		}
#endif

		private void SetTooltips()
		{
			SetThisToolTip( txtIntroText, StrRes.Tooltips.UC102.VistASignOntxtIntroText() );
			SetThisToolTip( btnSignOn, StrRes.Tooltips.UC102.VistASignOnbtnSignOn() );
			SetThisToolTip( txtAccessCode, StrRes.Tooltips.UC102.VistASignOntxtAccessCode() );
			SetThisToolTip( chbChangeVerifyCode, StrRes.Tooltips.UC102.VistASignOnchbChangeVerifyCode() );
			SetThisToolTip( txtVerifyCode, StrRes.Tooltips.UC102.VistASignOntxtVerifyCode() );
			SetThisToolTip( btnCancel, StrRes.Tooltips.UC102.VistASignOnbtnCancel() );
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgVistASignOn));
			this.txtIntroText = new System.Windows.Forms.TextBox();
			this.txtAccessCode = new System.Windows.Forms.TextBox();
			this.txtVerifyCode = new System.Windows.Forms.TextBox();
			this.chbChangeVerifyCode = new System.Windows.Forms.CheckBox();
			this.btnCancel = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnSignOn = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.lblVerifyCode = new System.Windows.Forms.Label();
			this.lblAccessCode = new System.Windows.Forms.Label();
			this.grpbIdentificationRequired = new System.Windows.Forms.GroupBox();
			this.pbVALogo = new System.Windows.Forms.PictureBox();
			this.grpbIdentificationRequired.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(592, 30);
			this.vbecsLogo1.Title = "VistA Logon";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 373);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// txtIntroText
			// 
			this.txtIntroText.AccessibleDescription = "VistA Logon";
			this.txtIntroText.AccessibleName = "VistA Logon";
			this.txtIntroText.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtIntroText.BackColor = System.Drawing.SystemColors.Info;
			this.txtIntroText.CausesValidation = false;
			this.txtIntroText.Cursor = System.Windows.Forms.Cursors.Default;
			this.txtIntroText.Font = new System.Drawing.Font("Lucida Console", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtIntroText.ForeColor = System.Drawing.SystemColors.InfoText;
			this.txtIntroText.Location = new System.Drawing.Point(0, 32);
			this.txtIntroText.Multiline = true;
			this.txtIntroText.Name = "txtIntroText";
			this.txtIntroText.ReadOnly = true;
			this.txtIntroText.ScrollBars = System.Windows.Forms.ScrollBars.Both;
			this.txtIntroText.Size = new System.Drawing.Size(592, 232);
			this.txtIntroText.TabIndex = 1;
			this.txtIntroText.TabStop = false;
			this.txtIntroText.Text = "";
			this.txtIntroText.WordWrap = false;
			// 
			// txtAccessCode
			// 
			this.txtAccessCode.AccessibleDescription = "Access Code";
			this.txtAccessCode.AccessibleName = "Access Code";
			this.txtAccessCode.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtAccessCode.Location = new System.Drawing.Point(248, 296);
			this.txtAccessCode.MaxLength = 255;
			this.txtAccessCode.Name = "txtAccessCode";
			this.txtAccessCode.PasswordChar = '*';
			this.txtAccessCode.Size = new System.Drawing.Size(200, 20);
			this.txtAccessCode.TabIndex = 1;
			this.txtAccessCode.Text = "";
			// 
			// txtVerifyCode
			// 
			this.txtVerifyCode.AccessibleDescription = "Verify Code";
			this.txtVerifyCode.AccessibleName = "Verify Code";
			this.txtVerifyCode.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtVerifyCode.Location = new System.Drawing.Point(248, 328);
			this.txtVerifyCode.MaxLength = 255;
			this.txtVerifyCode.Name = "txtVerifyCode";
			this.txtVerifyCode.PasswordChar = '*';
			this.txtVerifyCode.Size = new System.Drawing.Size(200, 20);
			this.txtVerifyCode.TabIndex = 2;
			this.txtVerifyCode.Text = "";
			// 
			// chbChangeVerifyCode
			// 
			this.chbChangeVerifyCode.AccessibleDescription = "Change Verify Code";
			this.chbChangeVerifyCode.AccessibleName = "Change Verify Code";
			this.chbChangeVerifyCode.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.chbChangeVerifyCode.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.chbChangeVerifyCode.Location = new System.Drawing.Point(249, 352);
			this.chbChangeVerifyCode.Name = "chbChangeVerifyCode";
			this.chbChangeVerifyCode.Size = new System.Drawing.Size(200, 24);
			this.chbChangeVerifyCode.TabIndex = 4;
			this.chbChangeVerifyCode.Text = "Change &Verify Code";
			this.chbChangeVerifyCode.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Image = null;
			this.btnCancel.Location = new System.Drawing.Point(328, 74);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.Size = new System.Drawing.Size(96, 24);
			this.btnCancel.TabIndex = 5;
			this.btnCancel.Text = "Cancel";
			// 
			// btnSignOn
			// 
			this.btnSignOn.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSignOn.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSignOn.Image = null;
			this.btnSignOn.Location = new System.Drawing.Point(328, 24);
			this.btnSignOn.Name = "btnSignOn";
			this.btnSignOn.Size = new System.Drawing.Size(96, 24);
			this.btnSignOn.TabIndex = 3;
			//CR 3087
			this.btnSignOn.Text = "Log On";
			// 
			// lblVerifyCode
			// 
			this.lblVerifyCode.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.lblVerifyCode.Location = new System.Drawing.Point(16, 59);
			this.lblVerifyCode.Name = "lblVerifyCode";
			this.lblVerifyCode.Size = new System.Drawing.Size(72, 24);
			this.lblVerifyCode.TabIndex = 1;
			this.lblVerifyCode.Text = "Verify Code*";
			// 
			// lblAccessCode
			// 
			this.lblAccessCode.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.lblAccessCode.Location = new System.Drawing.Point(16, 27);
			this.lblAccessCode.Name = "lblAccessCode";
			this.lblAccessCode.Size = new System.Drawing.Size(80, 16);
			this.lblAccessCode.TabIndex = 0;
			this.lblAccessCode.Text = "Access Code*";
			// 
			// grpbIdentificationRequired
			// 
			this.grpbIdentificationRequired.AccessibleDescription = "Authorization";
			this.grpbIdentificationRequired.AccessibleName = "Authorization";
			this.grpbIdentificationRequired.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpbIdentificationRequired.Controls.Add(this.btnCancel);
			this.grpbIdentificationRequired.Controls.Add(this.btnSignOn);
			this.grpbIdentificationRequired.Controls.Add(this.lblVerifyCode);
			this.grpbIdentificationRequired.Controls.Add(this.lblAccessCode);
			this.grpbIdentificationRequired.Location = new System.Drawing.Point(152, 272);
			this.grpbIdentificationRequired.Name = "grpbIdentificationRequired";
			this.grpbIdentificationRequired.Size = new System.Drawing.Size(440, 112);
			this.grpbIdentificationRequired.TabIndex = 6;
			this.grpbIdentificationRequired.TabStop = false;
			this.grpbIdentificationRequired.Text = "Authorization";
			// 
			// pbVALogo
			// 
			this.pbVALogo.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.pbVALogo.Image = ((System.Drawing.Image)(resources.GetObject("pbVALogo.Image")));
			this.pbVALogo.Location = new System.Drawing.Point(18, 293);
			this.pbVALogo.Name = "pbVALogo";
			this.pbVALogo.Size = new System.Drawing.Size(114, 74);
			this.pbVALogo.TabIndex = 7;
			this.pbVALogo.TabStop = false;
			// 
			// DlgVistASignOn
			// 
			this.AcceptButton = this.btnSignOn;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(592, 413);
			this.Controls.Add(this.pbVALogo);
			this.Controls.Add(this.chbChangeVerifyCode);
			this.Controls.Add(this.txtVerifyCode);
			this.Controls.Add(this.txtAccessCode);
			this.Controls.Add(this.txtIntroText);
			this.Controls.Add(this.grpbIdentificationRequired);
			this.hlphelpChm.SetHelpKeyword(this, "Log_onto_VBECS_and_VistA.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MinimumSize = new System.Drawing.Size(600, 440);
			this.Name = "DlgVistASignOn";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VistA Logon - Authorization";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgVistASignOn_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.grpbIdentificationRequired, 0);
			this.Controls.SetChildIndex(this.txtIntroText, 0);
			this.Controls.SetChildIndex(this.txtAccessCode, 0);
			this.Controls.SetChildIndex(this.txtVerifyCode, 0);
			this.Controls.SetChildIndex(this.chbChangeVerifyCode, 0);
			this.Controls.SetChildIndex(this.pbVALogo, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpbIdentificationRequired.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Handler needed to switch to single entry mode (both access and verify are entered into the same text box ).
		/// </summary>
		/// <param name="sender">Standard sender object.</param>
		/// <param name="e">Standard event arguments.</param>
		private void AccessCodeTextBox_TextChanged( object sender, EventArgs e )
		{	
			int _indexOfFirstDelimiter = txtAccessCode.Text.IndexOf( VISTA_SECURITY_CODES_USER_CONVENIENCE_DELIMITER );
			bool _singleEntryModeFlagNewValue = (_indexOfFirstDelimiter != -1);
			
			SetFormSingleEntryMode( _singleEntryModeFlagNewValue );

			SetMultipleDelimitersEnteredError( _singleEntryModeFlagNewValue && _indexOfFirstDelimiter != txtAccessCode.Text.LastIndexOf( VISTA_SECURITY_CODES_USER_CONVENIENCE_DELIMITER ) );
		}

		/// <summary>
		/// Switches form to single entry mode (both access and verify codes are entered into access code text box)
		/// adjusting appropriate controls - textboxes, labels and error providers. 
		/// </summary>
		/// <param name="singleEntryMode">Flag indicating whether it is single entry mode.</param>
		private void SetFormSingleEntryMode( bool singleEntryMode )
		{
			if( singleEntryMode == _singleEntryMode )
				return;

			_singleEntryMode = singleEntryMode;						

			txtVerifyCode.Enabled = !singleEntryMode;

			ResetErpValidationMessages();			

			if( singleEntryMode )
			{
				txtVerifyCode.TextAlign = HorizontalAlignment.Center;
				txtVerifyCode.PasswordChar = (char)0;
				txtVerifyCode.Text = StrRes.OtherMsg.UC102.SingleEntryModeVerifyCodeTextBoxCaption().ResString;
				lblAccessCode.Text = StrRes.OtherMsg.UC102.CombinedAccessAndVerifyLabel( VISTA_SECURITY_CODES_USER_CONVENIENCE_DELIMITER ).ResString;				
				lblVerifyCode.Text = String.Empty;
			}
			else
			{
				txtVerifyCode.TextAlign = HorizontalAlignment.Left;
				txtVerifyCode.PasswordChar = PASSWORD_CHAR;
				txtVerifyCode.Text = String.Empty;
				lblAccessCode.Text	= StrRes.OtherMsg.UC102.AccessCodeLabel().ResString;
				lblVerifyCode.Text = StrRes.OtherMsg.UC102.VerifyCodeLabel().ResString;
			}
		}

		/// <summary>
		/// Sets/clears error provider when more than one delimiter character was entered in single entry mode. 
		/// </summary>
		/// <param name="setMultipleDelimitersEnteredError">Flag indicating whether to set an error or clear it.</param>
		private void SetMultipleDelimitersEnteredError( bool setMultipleDelimitersEnteredError )
		{
			if( setMultipleDelimitersEnteredError == _multipleDelimitersErrorSetFlag )
				return;

			_multipleDelimitersErrorSetFlag = setMultipleDelimitersEnteredError;
			
			btnSignOn.EnabledButton = !setMultipleDelimitersEnteredError;

			if( setMultipleDelimitersEnteredError )
			{
				this.AcceptButton = null;
				SetErpValidationErrorMessage( txtAccessCode, StrRes.ValidMsg.UC102.OnlyOneDelimiterMayBeEntered( VISTA_SECURITY_CODES_USER_CONVENIENCE_DELIMITER_CHAR_NAME ).ResString );				
			}
			else
			{
				this.AcceptButton = btnSignOn;
				ResetErpValidationMessages();
			}						
		}

		/// <summary>
		/// Clear Form Controls Validation Error Messages
		/// </summary>
		protected override void ClearFormControlsValidationErrorMessages()
		{
			ClearControlValidationErrorMessage( txtAccessCode );
			ClearControlValidationErrorMessage( txtVerifyCode );
		}

		/// <summary>
		/// Overrided method indicating whether all form data is valid.
		/// </summary>
		/// <returns>True if all form data is valid. Otherwise - false.</returns>
		protected override bool IsValidErrorProviderBoundCheck()
		{
			if( !_singleEntryMode )
				return ForcedCheckLogicAnd( ValidateSecurityCodeTextBox( txtAccessCode ), ValidateSecurityCodeTextBox( txtVerifyCode ) );
			else
				return IsCombinedSecurityCodesStringValidCheck();
		}

		/// <summary>
		/// Checks if both access and verify codes entered in single entry mode are valid and 
		/// sets or clears appropriate validation error message if either one of them is not (or both).
		/// </summary>
		/// <returns>True if both codes are valid, false otherwise.</returns>
		private bool IsCombinedSecurityCodesStringValidCheck()
		{
			string[] _codes = GetAccessAndVerifyInSingleLineMode();

			bool _isAccessCodeValid, _isVerifyCodeValid;
			string _accessCodeValidationMessage, _verifyCodeValidationMessage;

			_isAccessCodeValid = VistASecurityCode.IsValidCodeString( _codes[0], out _accessCodeValidationMessage );
			_isVerifyCodeValid = VistASecurityCode.IsValidCodeString( _codes[1], out _verifyCodeValidationMessage );

			if( _isAccessCodeValid && _isVerifyCodeValid )
			{
				ClearFormControlsValidationErrorMessages();
				return true;
			}

			string _validationErrorMessage = StrRes.OtherMsg.UC102.CombinedValidationMessageTemplate(
				_isAccessCodeValid ? StrRes.OtherMsg.UC102.OKPartOfCombinedValidationMessage().ResString : _accessCodeValidationMessage, 
				Environment.NewLine,
				_isVerifyCodeValid ? StrRes.OtherMsg.UC102.OKPartOfCombinedValidationMessage().ResString : _verifyCodeValidationMessage ).ResString;

			SetErpValidationErrorMessage( txtAccessCode, _validationErrorMessage );

			return false;
		}

		private string[] GetAccessAndVerifyInSingleLineMode()
		{
			return txtAccessCode.Text.Split( new char[]{ VISTA_SECURITY_CODES_USER_CONVENIENCE_DELIMITER }, 2 );
		}

		/// <summary>
		/// Gets new instance of <see cref="VistASecurityCode"/> object representing VistA 
		/// access code created from text entered by user.
		/// </summary>
		public VistASecurityCode GetAccessCode()
		{
			return new VistASecurityCode( _singleEntryMode ? GetAccessAndVerifyInSingleLineMode()[0] : txtAccessCode.Text );
		}

		/// <summary>
		/// Gets new instance of <see cref="VistASecurityCode"/> object representing VistA 
		/// verify code created from text entered by user.
		/// </summary>
		public VistASecurityCode GetVerifyCode()
		{
			return new VistASecurityCode( _singleEntryMode ? GetAccessAndVerifyInSingleLineMode()[1] : txtVerifyCode.Text );
		}

		/// <summary>
		/// Flag indicating whether user wants to change verify code.
		/// </summary>
		public bool IsVerifyCodeChangeRequired
		{
			get
			{				
				return chbChangeVerifyCode.Checked;
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgVistASignOn_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			//no tooltips to speak... speak only error providers
			this.SpeakMessage( "" );	
		}

		
	}
}
